<?php

declare(strict_types=1);

namespace Erlage\Photogram\Tools;

use RecursiveIteratorIterator;
use RecursiveDirectoryIterator;

final class FileSystemUtils
{
    public static function directories(string $folderPath): array
    {
        return \array_filter(\glob($folderPath . '/*'), 'is_dir');
    }

    public static function filesRecursive(string $folderPath): RecursiveIteratorIterator
    {
        return new RecursiveIteratorIterator(new RecursiveDirectoryIterator($folderPath));
    }

    public static function generateIdentifierFromUserId(string $userId, string $suffix = '.png'): string
    {
        return \random_int(1111, 9999) . \time() . $userId . Crypto::randomString(10, false) . $suffix;
    }

    public static function covertUrlPathToDirPath(string $urlPath, string $constantType): string
    {
        return \str_replace(\constant("URL_PATH_{$constantType}_DISPLAY_CONTENT"), \constant("DIR_PATH_{$constantType}_DISPLAY_CONTENT"), $urlPath);
    }
}
